/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betternether.blocks;

import com.google.common.collect.Lists;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_47;
import net.minecraft.class_5819;
import org.betterx.betternether.BlocksHelper;
import org.betterx.betternether.MHelper;
import org.betterx.betternether.blocks.BNRenderLayer;
import org.betterx.betternether.blocks.BlockBaseNotFull;
import org.betterx.betternether.blocks.materials.Materials;
import org.betterx.betternether.interfaces.SurvivesOnSoulGround;
import org.betterx.betternether.registry.NetherBlocks;
import org.betterx.betternether.world.features.SoulLilyFeature;

public class BlockSoulLily
extends BlockBaseNotFull
implements SurvivesOnSoulGround {
    public static final class_2754<SoulLilyShape> SHAPE = class_2754.method_11850((String)"shape", SoulLilyShape.class);
    private static final class_265 SHAPE_SMALL = BlockSoulLily.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final class_265 SHAPE_MEDIUM_BOTTOM = BlockSoulLily.method_9541((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final class_265 SHAPE_MEDIUM_TOP = BlockSoulLily.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final class_265 SHAPE_BIG_BOTTOM = BlockSoulLily.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final class_265 SHAPE_BIG_MIDDLE = BlockSoulLily.method_9541((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final class_265 SHAPE_BIG_TOP_CENTER = BlockSoulLily.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    private static final class_265 SHAPE_BIG_TOP_SIDE_N = BlockSoulLily.method_9541((double)0.0, (double)4.0, (double)0.0, (double)16.0, (double)6.0, (double)8.0);
    private static final class_265 SHAPE_BIG_TOP_SIDE_S = BlockSoulLily.method_9541((double)0.0, (double)4.0, (double)8.0, (double)16.0, (double)6.0, (double)16.0);
    private static final class_265 SHAPE_BIG_TOP_SIDE_E = BlockSoulLily.method_9541((double)8.0, (double)4.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private static final class_265 SHAPE_BIG_TOP_SIDE_W = BlockSoulLily.method_9541((double)0.0, (double)4.0, (double)0.0, (double)8.0, (double)6.0, (double)16.0);
    private static final SoulLilyFeature STRUCTURE = new SoulLilyFeature();
    private static final SoulLilyShape[] ROT = new SoulLilyShape[]{SoulLilyShape.BIG_TOP_SIDE_N, SoulLilyShape.BIG_TOP_SIDE_E, SoulLilyShape.BIG_TOP_SIDE_S, SoulLilyShape.BIG_TOP_SIDE_W};

    public BlockSoulLily() {
        super(Materials.makeWood(class_3620.field_15987).method_22488().method_9640());
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(SHAPE, (Comparable)((Object)SoulLilyShape.SMALL)));
        this.setRenderLayer(BNRenderLayer.CUTOUT);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateManager) {
        stateManager.method_11667(new class_2769[]{SHAPE});
    }

    public class_265 method_9530(class_2680 state, class_1922 view, class_2338 pos, class_3726 ePos) {
        switch ((SoulLilyShape)((Object)state.method_11654(SHAPE))) {
            case BIG_BOTTOM: {
                return SHAPE_BIG_BOTTOM;
            }
            case BIG_MIDDLE: {
                return SHAPE_BIG_MIDDLE;
            }
            case BIG_TOP_CENTER: {
                return SHAPE_BIG_TOP_CENTER;
            }
            case MEDIUM_BOTTOM: {
                return SHAPE_MEDIUM_BOTTOM;
            }
            case MEDIUM_TOP: {
                return SHAPE_MEDIUM_TOP;
            }
            case BIG_TOP_SIDE_N: {
                return SHAPE_BIG_TOP_SIDE_N;
            }
            case BIG_TOP_SIDE_S: {
                return SHAPE_BIG_TOP_SIDE_S;
            }
            case BIG_TOP_SIDE_E: {
                return SHAPE_BIG_TOP_SIDE_E;
            }
            case BIG_TOP_SIDE_W: {
                return SHAPE_BIG_TOP_SIDE_W;
            }
        }
        return SHAPE_SMALL;
    }

    public boolean canGrow(class_1937 world, class_2338 pos, class_5819 random) {
        class_2680 state = world.method_8320(pos.method_10074());
        if (state.method_26204() == this || state.method_26204() == class_2246.field_10114 || BlocksHelper.isFertile(world.method_8320(pos.method_10074()))) {
            return BlocksHelper.isFertile(world.method_8320(pos.method_10074())) ? random.method_43048(8) == 0 : random.method_43048(16) == 0;
        }
        return false;
    }

    public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        super.method_9588(state, world, pos, random);
        if (this.canGrow((class_1937)world, pos, random)) {
            SoulLilyShape shape = (SoulLilyShape)((Object)state.method_11654(SHAPE));
            if (shape == SoulLilyShape.SMALL && world.method_22347(pos.method_10084())) {
                STRUCTURE.growMedium((class_1936)world, pos);
            } else if (shape == SoulLilyShape.MEDIUM_BOTTOM && world.method_22347(pos.method_10086(2)) && this.isAirSides((class_1937)world, pos.method_10086(2))) {
                STRUCTURE.growBig((class_1936)world, pos);
            }
        }
    }

    private boolean isAirSides(class_1937 world, class_2338 pos) {
        return world.method_22347(pos.method_10095()) && world.method_22347(pos.method_10072()) && world.method_22347(pos.method_10078()) && world.method_22347(pos.method_10067());
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        SoulLilyShape shape = (SoulLilyShape)((Object)state.method_11654(SHAPE));
        int index = this.getRotationIndex(shape);
        if (index < 0) {
            return state;
        }
        int offset = this.rotOffset(rotation);
        return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)ROT[index + offset & 3]));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        SoulLilyShape shape = (SoulLilyShape)((Object)state.method_11654(SHAPE));
        int index = this.getRotationIndex(shape);
        if (index < 0) {
            return state;
        }
        if (mirror == class_2415.field_11301) {
            if (shape == SoulLilyShape.BIG_TOP_SIDE_E) {
                shape = SoulLilyShape.BIG_TOP_SIDE_W;
            } else if (shape == SoulLilyShape.BIG_TOP_SIDE_W) {
                shape = SoulLilyShape.BIG_TOP_SIDE_E;
            }
        } else if (mirror == class_2415.field_11300) {
            if (shape == SoulLilyShape.BIG_TOP_SIDE_N) {
                shape = SoulLilyShape.BIG_TOP_SIDE_S;
            } else if (shape == SoulLilyShape.BIG_TOP_SIDE_S) {
                shape = SoulLilyShape.BIG_TOP_SIDE_N;
            }
        }
        return (class_2680)state.method_11657(SHAPE, (Comparable)((Object)shape));
    }

    private int getRotationIndex(SoulLilyShape shape) {
        for (int i = 0; i < 4; ++i) {
            if (shape != ROT[i]) continue;
            return i;
        }
        return -1;
    }

    private int rotOffset(class_2470 rotation) {
        if (rotation == class_2470.field_11467) {
            return 0;
        }
        if (rotation == class_2470.field_11463) {
            return 1;
        }
        if (rotation == class_2470.field_11464) {
            return 2;
        }
        return 3;
    }

    @Environment(value=EnvType.CLIENT)
    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        return new class_1799((class_1935)NetherBlocks.SOUL_LILY_SAPLING);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        Comparable _shape = (Comparable)state.method_11656().get(SHAPE);
        if (_shape == null) {
            return false;
        }
        SoulLilyShape shape = (SoulLilyShape)((Object)SHAPE.method_11902().cast(_shape));
        if (shape == SoulLilyShape.BIG_TOP_SIDE_N) {
            return world.method_8320(pos.method_10095()).method_26204() == this;
        }
        if (shape == SoulLilyShape.BIG_TOP_SIDE_S) {
            return world.method_8320(pos.method_10072()).method_26204() == this;
        }
        if (shape == SoulLilyShape.BIG_TOP_SIDE_E) {
            return world.method_8320(pos.method_10078()).method_26204() == this;
        }
        if (shape == SoulLilyShape.BIG_TOP_SIDE_W) {
            return world.method_8320(pos.method_10067()).method_26204() == this;
        }
        class_2680 down = world.method_8320(pos.method_10074());
        return down.method_26204() == this || this.isSurvivable(down);
    }

    public class_2680 method_9559(class_2680 state, class_2350 facing, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        return this.method_9558(state, (class_4538)world, pos) ? state : class_2246.field_10124.method_9564();
    }

    @Override
    public List<class_1799> method_9560(class_2680 state, class_47.class_48 builder) {
        switch ((SoulLilyShape)((Object)state.method_11654(SHAPE))) {
            case BIG_BOTTOM: 
            case BIG_MIDDLE: {
                return Lists.newArrayList((Object[])new class_1799[]{new class_1799((class_1935)NetherBlocks.MAT_NETHER_MUSHROOM.getStem())});
            }
            case BIG_TOP_CENTER: {
                return Lists.newArrayList((Object[])new class_1799[]{new class_1799((class_1935)NetherBlocks.MAT_NETHER_MUSHROOM.getStem()), new class_1799((class_1935)NetherBlocks.SOUL_LILY_SAPLING)});
            }
            case MEDIUM_BOTTOM: {
                return Lists.newArrayList((Object[])new class_1799[]{new class_1799((class_1935)NetherBlocks.MAT_NETHER_MUSHROOM.getStem())});
            }
            case BIG_TOP_SIDE_N: 
            case BIG_TOP_SIDE_S: 
            case BIG_TOP_SIDE_E: 
            case BIG_TOP_SIDE_W: {
                return Lists.newArrayList((Object[])new class_1799[]{new class_1799((class_1935)NetherBlocks.MAT_NETHER_MUSHROOM.getStem()), new class_1799((class_1935)NetherBlocks.SOUL_LILY_SAPLING, MHelper.randRange(0, 1, MHelper.RANDOM))});
            }
        }
        return Lists.newArrayList((Object[])new class_1799[]{new class_1799((class_1935)NetherBlocks.MAT_NETHER_MUSHROOM.getStem()), new class_1799((class_1935)NetherBlocks.SOUL_LILY_SAPLING)});
    }

    public static enum SoulLilyShape implements class_3542
    {
        SMALL("small"),
        MEDIUM_BOTTOM("medium_bottom"),
        MEDIUM_TOP("medium_top"),
        BIG_BOTTOM("big_bottom"),
        BIG_MIDDLE("big_middle"),
        BIG_TOP_CENTER("big_top_center"),
        BIG_TOP_SIDE_N("big_top_side_n"),
        BIG_TOP_SIDE_S("big_top_side_s"),
        BIG_TOP_SIDE_E("big_top_side_e"),
        BIG_TOP_SIDE_W("big_top_side_w");

        final String name;

        private SoulLilyShape(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

